/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.util;

import filenet.vw.base.DateHelper;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.PathUtils;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWConvertAES;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Properties;
import java.util.TreeMap;

public class SecureJSSEProps {
    private static final String ENC_PREFIX = "@";
    private static final String PEJSSE_FILENAME = "p8pejsse.properties";
    private static final String DIVIDER = "==========================================================================";

    private static String readString(String prompt) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(">" + prompt + ": ");
            return in.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromFile(String propFileName) {
        Properties p = new Properties();
        File f = new File(propFileName);
        if (f.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                p.load(in);
            }
            catch (Exception e) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return p;
    }

    private static String getRealValue(String val, boolean decryptIt) {
        if (val != null && (val = val.trim()).startsWith(ENC_PREFIX) && decryptIt) {
            try {
                VWAuthItem n = new VWConvertAES().getDString(val.substring(1));
                val = n.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val;
    }

    private static void printPrelude(String fileName, Properties p) {
        System.out.printf("\n\n\n", new Object[0]);
        System.out.println(DIVIDER);
        System.out.printf("The following JSSE properties will be read from and written to\n%s\n", fileName);
        System.out.println(DIVIDER);
        for (PROPS aProp : PROPS.values()) {
            String propName = aProp.getName();
            System.out.printf("\t%s\n", propName);
        }
        System.out.println(DIVIDER);
        System.out.printf("\n\n\n", new Object[0]);
    }

    private static void postWork(String fileName) {
        System.out.printf("\n\nTo use these system properties in PE applications:\n", new Object[0]);
        System.out.printf("1.  For Process Engine Server applications, put %s in the ProcessEngine/data directory\n", fileName);
        System.out.printf("2.  For Component Manager applications, put %s in the Router/lib directory.", fileName);
        System.out.println("3.  Restart the applications.\n\n");
    }

    public static void main(String[] args) {
        String propFileName = PEJSSE_FILENAME;
        Properties p = SecureJSSEProps.loadPropertiesFromFile(propFileName);
        SecureJSSEProps.printPrelude(propFileName, p);
        boolean isModified = false;
        for (PROPS aProp : PROPS.values()) {
            String propName = aProp.getName();
            String propVal = SecureJSSEProps.getRealValue(p.getProperty(propName), true);
            if (propVal != null) {
                String wantReset = SecureJSSEProps.readString(String.format("Do you want to reset the value for %s [%s] (Y/N, CR=N)? ", propName, propVal));
                if (wantReset == null) {
                    System.exit(1);
                }
                if (!wantReset.toUpperCase().equals("Y")) continue;
                propVal = null;
            }
            if ((propVal = SecureJSSEProps.readString(String.format("Enter the value for [%s] ", propName))) == null || propVal.length() == 0) {
                System.out.println("...Skipping " + propName);
                continue;
            }
            try {
                if (aProp.getEncrypted()) {
                    propVal = ENC_PREFIX + new VWConvertAES().getEString(propVal, propVal);
                }
                System.out.printf("...Setting %s=%s\n", propName, propVal);
                p.put(propName, propVal);
                isModified = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (isModified) {
            System.out.printf("\n\nWriting to %s\n", propFileName);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(propFileName);
                out.write(SecureJSSEProps.ppProperties(p).getBytes());
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            SecureJSSEProps.postWork(propFileName);
        }
    }

    private static String ppProperties(Properties p) {
        if (p == null) {
            return null;
        }
        StringBuilder b = new StringBuilder("## Modified on " + DateHelper.convertDateToUTCString(new Date())).append("\n");
        TreeMap<Object, Object> t = new TreeMap<Object, Object>(p);
        for (String string : t.keySet()) {
            b.append(string).append("=");
            String value = p.getProperty(string);
            for (int j = 0; j < value.length(); ++j) {
                char c = value.charAt(j);
                switch (c) {
                    case ':': 
                    case '=': 
                    case '\\': {
                        b.append('\\');
                    }
                }
                b.append(c);
            }
            b.append("\n");
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties SetJSSEProps() {
        Properties p = null;
        PathUtils myPath = new PathUtils();
        String propFileName = PEJSSE_FILENAME;
        String datadir = JVMSystemConstants.GetPrivilegedSystemProperty("JPEDATA_DIR");
        if (datadir != null) {
            myPath.addPath(datadir);
        }
        InputStream in = null;
        try {
            in = myPath.getResourceAsStream(propFileName);
            p = new Properties();
            p.load(in);
        }
        catch (Exception t) {
            p = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception t) {}
            }
        }
        if (p == null) {
            return null;
        }
        Properties res = new Properties();
        for (PROPS aProp : PROPS.values()) {
            String propName = aProp.getName();
            String filePropVal = p.getProperty(propName);
            String propVal = SecureJSSEProps.getRealValue(filePropVal, true);
            if (propVal == null) continue;
            JVMSystemConstants.SetPrivilegedSystemProperty(propName, propVal);
            res.put(propName, filePropVal);
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PROPS {
        TRUSTSTORE("javax.net.ssl.trustStore", false),
        TRUSTSTORE_PW("javax.net.ssl.trustStorePassword", true),
        KEYTORE("javax.net.ssl.keyStore", false),
        KEYSTORE_PW("javax.net.ssl.keyStorePassword", true);

        private String name;
        private boolean encrypted;

        private PROPS(String name, boolean encrypted) {
            this.name = name;
            this.encrypted = encrypted;
        }

        protected String getName() {
            return this.name;
        }

        protected boolean getEncrypted() {
            return this.encrypted;
        }
    }
}

